function [Kx,M,H,R,G,betas,gammas] = Observer_controller_design(A,B,Fa,D,C,Fs,Mc,Nc,L)

[n,m] = size(B);
[~,q] = size(Fa);
[~,l] = size(D);
[p,q1] = size(Fs);


% Augmented system
bar_A = [A Fa zeros(n,q); zeros(q+q1,n+q+q1)]; 
bar_B = [B;zeros(q+q1,m)]; 
bar_D = [D zeros(n,q+q1);zeros(q+q1,l) eye(q+q1)]; 
bar_C = [C zeros(p,q) Fs]; 

% Examine the conditions of Lemma 5.1, Eq.(5.11)
C1_LHS = [L*bar_A;bar_C;bar_C*bar_A;L]; 
C1_RHS = [bar_C;bar_C*bar_A;L]; 

r_C1_LHS = rank(C1_LHS);
r_C1_RHS = rank(C1_RHS);

if r_C1_LHS == r_C1_RHS
    disp('1: Lemma 5.1 condition satisfied!');
else
    disp('1: Lemma 5.1 condition not satisfied!');
end

% Examine the conditions of Lemma 5.2, Eq.(5.15)
syms s;
C2_LHS = [s*L - L*bar_A; bar_C; bar_C*bar_A]; 
C2_RHS = [bar_C;bar_C*bar_A;L]; 

r_C2_LHS = rank(C2_LHS);
r_C2_RHS = rank(C2_RHS);

if r_C2_LHS == r_C2_RHS
    disp('2: Lemma 5.2 condition satisfied!');
else
    disp('2: Lemma 5.2 condition not satisfied!');
end

% Solve optimization Eq.(5.49)
% Obtain parameterized matrices
S1 = pinv(L); 
S2 = eye(n+q+q1) - pinv(L)*L; 
Psi = L*bar_A*S2; 
Omega = [bar_C*S2; bar_C*bar_A*S2]; 

tau = [bar_C*S1; bar_C*bar_A*S1]; 
M1 = L*bar_A*S1 - Psi * pinv(Omega) * tau;  
M2 = (eye(2*p) - Omega*pinv(Omega)) * tau; 
tau1 = [zeros(n,n);eye(p)];
H1 = Psi * pinv(Omega) * tau1;
H2 = (eye(2*p) - Omega*pinv(Omega)) * tau1; 
bar_H1 = H1*bar_C - L;
B_p = inv(B'*B)*B';

Y = 0.5*ones(m,n); 

N = B_p - Y * (eye(n) - B*B_p);
Theta1 = eye(n) - B*N;
F1 = [Fa zeros(p,q1)]; 
D1 = [Theta1*D zeros(n,q+q1)];

% Weights
Csx = [eye(n); zeros(q+q1,n)];
Cse = 1.0e-1*[zeros(n,q+q1); eye(q+q1)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
P0 = sdpvar(n,n);
Q0 = sdpvar(q+q1,q+q1);
hat_P0 = sdpvar(m,m);
R10 = sdpvar(m,n);
R20 = sdpvar(q+q1,2*p);
gamma0 = sdpvar(1,1);
beta0 = sdpvar(1,1);

cont = [];
cont = [cont, P0 >= eps*eye(n)];
cont = [cont, Q0 >= eps*eye(q+q1)];
cont = [cont, gamma0 >= 0];
cont = [cont, beta0 >= 0];
cont = [cont, [beta0*eye(n) P0*B - B*hat_P0;
               (P0*B - B*hat_P0)' beta0*eye(m)]];

LMI = blkvar;
LMI(1,1) = (P0*Theta1*A - B*R10) + (P0*Theta1*A - B*R10)' + 2*Nc'*Nc;
LMI(1,2) = P0*F1;
LMI(1,3) = P0*D1;
LMI(1,4) = P0*Theta1*Mc;
LMI(1,5) = zeros(n,n);
LMI(1,6) = Csx';

LMI(2,2) = (Q0*M1 - R20*M2) + (Q0*M1 - R20*M2)';
LMI(2,3) = (Q0*bar_H1 + R20*H2*bar_C)*bar_D;
LMI(2,4) = zeros(q+q1,n);
LMI(2,5) = (Q0*bar_H1 + R20*H2*bar_C)*[Mc;zeros(2,2)];
LMI(2,6) = Cse';

LMI(3,3) = -gamma0*eye(l+q+q1);
LMI(3,4) = zeros(l+q+q1,n);
LMI(3,5) = zeros(l+q+q1,n);
LMI(3,6) = zeros(l+q+q1,n+q+q1);

LMI(4,4) = -eye(n);
LMI(5,5) = -eye(n);
LMI(6,6) = -eye(n+q+q1);

LMI = sdpvar(LMI);

cont = [cont, LMI <= -eps*eye(3*(q+q1)+l+4*n)];
obj = 1.0e1*gamma0 + beta0;

ops = sdpsettings('solver','mosek','verbose','1');
optimize(cont,obj,ops);

gammas = sqrt(value(gamma0));
betas = value(beta0);

Q = value(Q0);
hat_P = value(hat_P0);
R1 = value(R10);
R2 = value(R20);

Kx = inv(hat_P)*R1;
Z = inv(Q)*R2;

M = M1 - Z*M2; 
H = H1 + Z*H2;
T = L - H*bar_C;

T1 = (Psi * pinv(Omega) + Z * (eye(2*p) - Omega*pinv(Omega))) * [eye(n);zeros(q+q1,q+q1)];

R =  M*H + T1; 
G = T*bar_B; 



